

BS = {};

function BS.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function BS:load(xmlFile)

local rotationNodegardziel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gardziel#index"));
    if rotationNodegardziel ~= nil then
        self.gardziel = {};
        self.gardziel.node = rotationNodegardziel;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gardziel#minRot"));
        self.gardziel.minRot = {};
        self.gardziel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gardziel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gardziel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gardziel#maxRot"));
        self.gardziel.maxRot = {};
        self.gardziel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gardziel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gardziel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.gardziel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.gardziel#rotTime"), 2)*1000;
        self.gardziel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.gardziel#touchRotLimit"), 10));
    end;


end;

function BS:delete()

end;

function BS:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_pageup then
		self.gardzielMax = isDown;
	end;
	if sym == Input.KEY_pagedown then
		self.gardzielMin = isDown;
	end;


	

end;

function BS:update(dt)
   
   	local doRotate = self.gardzielMax or self.gardzielMin 
	if self.gardziel ~= nil and doRotate then
        local x, y, z = getRotation(self.gardziel.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.gardziel.maxRot, self.gardziel.minRot, 3, self.gardziel.rotTime, dt, not self.gardzielMax);
        setRotation(self.gardziel.node, unpack(newRot));
    end;


 
 	
 	if self.rotationPartpedalhamulca ~= nil then
		local x, y, z = getRotation(self.rotationPartpedalhamulca.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalhamulca.maxRot, self.rotationPartpedalhamulca.minRot, 3, self.rotationPartpedalhamulca.rotTime, dt, not self.rotationMaxpedalhamulca);
		setRotation(self.rotationPartpedalhamulca.node, unpack(newRot));
	end;
 
end;	


function BS:draw()
   	if self.bshudOverlay ~= nil then
			if self.bcActive then
			self.bshudOverlay:render();
			end;
		end;
   if self.bcActive then
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.15, 0.02, "");
	else
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.15, 0.02, "");
	end;

	
	
	if self.bcActive then
		renderText(0.055, 0.49, 0.027, "");
	
	if self.slomaActive then
		renderText(0.0515, 0.46, 0.020, "");
	else
		renderText(0.0515, 0.46, 0.020, "");
	end;
	if self.kogutAn  then
		renderText(0.0515, 0.44, 0.020, "");
	else
		renderText(0.0515, 0.44, 0.020, "");
	end;

	renderText(0.0515, 0.42, 0.020, "");
	if self.rotationMaxklapa2 then
		renderText(0.0515, 0.40, 0.020, "");
	else
		renderText(0.0515, 0.40, 0.020, "");
	end
	if self.halogenyActive  then
		renderText(0.0515, 0.38, 0.020, "");
	else
		renderText(0.0515, 0.38, 0.020, "");
	end;
	if self.halogenActive  then
		renderText(0.0515, 0.36, 0.020, "");
	else
		renderText(0.0515, 0.36, 0.020, "");
	end;
	if self.flashLeft  then
		renderText(0.0515, 0.34, 0.020, "");
	else
		renderText(0.0515, 0.34, 0.020, "");
	end;
	if self.flash  then
		renderText(0.0515, 0.32, 0.020, "");
	else
		renderText(0.0515, 0.32, 0.020, "");
	end;
	if self.flashRight  then
		renderText(0.0515, 0.30, 0.020, "");
	else
		renderText(0.0515, 0.30, 0.020, "");
	end;


end;

end;

function BS:validateAttacherJoint(implement, jointDesc, dt)
   return true;
end;








